/*
 * Decompiled with CFR 0.152.
 */
package vectorwing.farmersdelight.common;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.stream.Stream;
import net.fabricmc.api.EnvType;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.resource.conditions.v1.ResourceConditions;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1428;
import net.minecraft.class_1452;
import net.minecraft.class_1453;
import net.minecraft.class_1646;
import net.minecraft.class_1676;
import net.minecraft.class_1756;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2315;
import net.minecraft.class_2357;
import net.minecraft.class_2374;
import net.minecraft.class_2960;
import net.minecraft.class_2965;
import net.minecraft.class_3962;
import net.minecraft.class_7923;
import vectorwing.farmersdelight.common.Configuration;
import vectorwing.farmersdelight.common.crafting.condition.VanillaCrateEnabledCondition;
import vectorwing.farmersdelight.common.crafting.ingredient.ToolActionIngredient;
import vectorwing.farmersdelight.common.entity.RottenTomatoEntity;
import vectorwing.farmersdelight.common.registry.ModAdvancements;
import vectorwing.farmersdelight.common.registry.ModItems;

public class CommonSetup {
    public static void init() {
        if (FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT) {
            ClientLifecycleEvents.CLIENT_STARTED.register(client -> CommonSetup.registerStackSizeOverrides());
        }
        ServerLifecycleEvents.SERVER_STARTING.register(server -> {
            if (server.method_3816()) {
                CommonSetup.registerStackSizeOverrides();
            }
        });
        CommonSetup.registerCompostables();
        CommonSetup.registerDispenserBehaviors();
        CommonSetup.registerItemSetAdditions();
        CommonSetup.registerAnimalFeeds();
        ModAdvancements.register();
        ResourceConditions.register((class_2960)VanillaCrateEnabledCondition.ID, jsonObject -> Configuration.ENABLE_VANILLA_CROP_CRATES.get());
        ToolActionIngredient.register();
    }

    public static void registerStackSizeOverrides() {
        if (!Configuration.ENABLE_STACKABLE_SOUP_ITEMS.get().booleanValue()) {
            return;
        }
        Configuration.SOUP_ITEM_LIST.get().forEach(key -> {
            class_1792 item = (class_1792)class_7923.field_41178.method_10223(new class_2960(key));
            if (item instanceof class_1756) {
                item.field_8013 = 16;
            }
        });
    }

    public static void registerDispenserBehaviors() {
        class_2315.method_10009((class_1935)((class_1935)ModItems.ROTTEN_TOMATO.get()), (class_2357)new class_2965(){

            protected class_1676 method_12844(class_1937 pLevel, class_2374 pPosition, class_1799 pStack) {
                return new RottenTomatoEntity(pLevel, pPosition.method_10216(), pPosition.method_10214(), pPosition.method_10215());
            }
        });
    }

    public static void registerCompostables() {
        class_3962.field_17566.put((Object)((class_1935)ModItems.TREE_BARK.get()), 0.3f);
        class_3962.field_17566.put((Object)((class_1935)ModItems.STRAW.get()), 0.3f);
        class_3962.field_17566.put((Object)((class_1935)ModItems.CABBAGE_SEEDS.get()), 0.3f);
        class_3962.field_17566.put((Object)((class_1935)ModItems.TOMATO_SEEDS.get()), 0.3f);
        class_3962.field_17566.put((Object)((class_1935)ModItems.RICE.get()), 0.3f);
        class_3962.field_17566.put((Object)((class_1935)ModItems.RICE_PANICLE.get()), 0.3f);
        class_3962.field_17566.put((Object)((class_1935)ModItems.SANDY_SHRUB.get()), 0.3f);
        class_3962.field_17566.put((Object)((class_1935)ModItems.PUMPKIN_SLICE.get()), 0.5f);
        class_3962.field_17566.put((Object)((class_1935)ModItems.CABBAGE_LEAF.get()), 0.5f);
        class_3962.field_17566.put((Object)((class_1935)ModItems.KELP_ROLL_SLICE.get()), 0.5f);
        class_3962.field_17566.put((Object)((class_1935)ModItems.CABBAGE.get()), 0.65f);
        class_3962.field_17566.put((Object)((class_1935)ModItems.ONION.get()), 0.65f);
        class_3962.field_17566.put((Object)((class_1935)ModItems.TOMATO.get()), 0.65f);
        class_3962.field_17566.put((Object)((class_1935)ModItems.WILD_CABBAGES.get()), 0.65f);
        class_3962.field_17566.put((Object)((class_1935)ModItems.WILD_ONIONS.get()), 0.65f);
        class_3962.field_17566.put((Object)((class_1935)ModItems.WILD_TOMATOES.get()), 0.65f);
        class_3962.field_17566.put((Object)((class_1935)ModItems.WILD_CARROTS.get()), 0.65f);
        class_3962.field_17566.put((Object)((class_1935)ModItems.WILD_POTATOES.get()), 0.65f);
        class_3962.field_17566.put((Object)((class_1935)ModItems.WILD_BEETROOTS.get()), 0.65f);
        class_3962.field_17566.put((Object)((class_1935)ModItems.WILD_RICE.get()), 0.65f);
        class_3962.field_17566.put((Object)((class_1935)ModItems.PIE_CRUST.get()), 0.65f);
        class_3962.field_17566.put((Object)((class_1935)ModItems.RICE_BALE.get()), 0.85f);
        class_3962.field_17566.put((Object)((class_1935)ModItems.SWEET_BERRY_COOKIE.get()), 0.85f);
        class_3962.field_17566.put((Object)((class_1935)ModItems.HONEY_COOKIE.get()), 0.85f);
        class_3962.field_17566.put((Object)((class_1935)ModItems.CAKE_SLICE.get()), 0.85f);
        class_3962.field_17566.put((Object)((class_1935)ModItems.APPLE_PIE_SLICE.get()), 0.85f);
        class_3962.field_17566.put((Object)((class_1935)ModItems.SWEET_BERRY_CHEESECAKE_SLICE.get()), 0.85f);
        class_3962.field_17566.put((Object)((class_1935)ModItems.CHOCOLATE_PIE_SLICE.get()), 0.85f);
        class_3962.field_17566.put((Object)((class_1935)ModItems.RAW_PASTA.get()), 0.85f);
        class_3962.field_17566.put((Object)((class_1935)ModItems.ROTTEN_TOMATO.get()), 0.85f);
        class_3962.field_17566.put((Object)((class_1935)ModItems.KELP_ROLL.get()), 0.85f);
        class_3962.field_17566.put((Object)((class_1935)ModItems.APPLE_PIE.get()), 1.0f);
        class_3962.field_17566.put((Object)((class_1935)ModItems.SWEET_BERRY_CHEESECAKE.get()), 1.0f);
        class_3962.field_17566.put((Object)((class_1935)ModItems.CHOCOLATE_PIE.get()), 1.0f);
        class_3962.field_17566.put((Object)((class_1935)ModItems.DUMPLINGS.get()), 1.0f);
        class_3962.field_17566.put((Object)((class_1935)ModItems.STUFFED_PUMPKIN_BLOCK.get()), 1.0f);
        class_3962.field_17566.put((Object)((class_1935)ModItems.BROWN_MUSHROOM_COLONY.get()), 1.0f);
        class_3962.field_17566.put((Object)((class_1935)ModItems.RED_MUSHROOM_COLONY.get()), 1.0f);
    }

    public static void registerAnimalFeeds() {
    }

    public static void registerItemSetAdditions() {
        class_1856 newChickenFood = class_1856.method_8091((class_1935[])new class_1935[]{(class_1935)ModItems.CABBAGE_SEEDS.get(), (class_1935)ModItems.TOMATO_SEEDS.get(), (class_1935)ModItems.RICE.get()});
        class_1428.field_6742 = class_1856.method_26964(Stream.concat(Arrays.stream(class_1428.field_6742.method_8105()), Arrays.stream(newChickenFood.method_8105())));
        class_1856 newPigFood = class_1856.method_8091((class_1935[])new class_1935[]{(class_1935)ModItems.CABBAGE.get(), (class_1935)ModItems.TOMATO.get()});
        class_1452.field_6817 = class_1856.method_26964(Stream.concat(Arrays.stream(class_1452.field_6817.method_8105()), Arrays.stream(newPigFood.method_8105())));
        Collections.addAll(class_1453.field_6825, ModItems.CABBAGE_SEEDS.get(), ModItems.TOMATO_SEEDS.get(), ModItems.RICE.get());
        HashSet newWantedItems = Sets.newHashSet((Object[])new class_1792[]{ModItems.CABBAGE.get(), ModItems.TOMATO.get(), ModItems.ONION.get(), ModItems.RICE.get(), ModItems.CABBAGE_SEEDS.get(), ModItems.TOMATO_SEEDS.get(), ModItems.RICE_PANICLE.get()});
        newWantedItems.addAll(class_1646.field_18527);
        class_1646.field_18527 = ImmutableSet.copyOf((Collection)newWantedItems);
    }
}

